﻿using System;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.ServiceModel.Web;

namespace ProductLookupDemo
{
    [ServiceContract(Namespace = "http://ajaxbooksamples.com")]
    [
        AspNetCompatibilityRequirements(
        RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)
    ]
    public class Product
    {
        [OperationContract]
        public ProductDetail Lookup(string productNumber)
        {
            if (string.IsNullOrEmpty(productNumber))
                throw new ArgumentNullException("productNumber");

            return ProductSearch.Lookup(productNumber);
        }

        [OperationContract]
        public ProductDetail AdvancedLookup(SearchCriteria criteria)
        {
            if (criteria == null)
                throw new ArgumentNullException("criteria");

            return ProductSearch.Lookup(criteria.ProductNumber);
        }

    }
}
